

# to echo output, use 'source("main.R", echo=TRUE)'

# clear workspace
rm(list=ls())

# load libraries
library("ggplot2")



hist_top <- ggplot()+geom_histogram(aes(rnorm(100)))
empty <- ggplot()+geom_point(aes(1,1), colour="white") +
#  opts(axis.ticks=theme_blank(), 
#       panel.background=theme_blank(), 
#       axis.text.x=theme_blank(), axis.text.y=theme_blank(),           
#       axis.title.x=theme_blank(), axis.title.y=theme_blank())
# opts is deprecated, use theme instead
  theme(legend.position = "none",
         line = element_blank(),
         panel.background = element_blank(),
         axis.title.x = element_blank(),
         axis.title.y = element_blank(),
         axis.text.x = element_blank(),
         axis.text.y = element_blank()) + 
         #plot.margin = unit(c(3,-5.5,4,3), "mm")) +
  scale_x_continuous(breaks = 0:6,
                      limits = c(0,6),
                      expand = c(.05,.05))

scatter <- ggplot()+geom_point(aes(rnorm(100), rnorm(100)))
hist_right <- ggplot()+geom_histogram(aes(rnorm(100)))+coord_flip()


grid.arrange(hist_top, empty, scatter, hist_right, ncol=2, nrow=2, widths=c(4, 1), heights=c(1, 4))

